# Generated by Django 2.2.8 on 2019-12-11 14:12
import mimetypes

from django.db import migrations

from ..utils import bytes_to_human, get_pdf_information


def fill_new_values(apps, schema_editor):
    Mediafile = apps.get_model("mediafiles", "Mediafile")
    for mediafile in Mediafile.objects.all():
        if not mediafile.is_directory:
            mediafile.filesize = bytes_to_human(mediafile.mediafile.size)
            mediafile.mimetype = mimetypes.guess_type(mediafile.mediafile.name)[0]
            if mediafile.mimetype == "application/pdf":
                mediafile.pdf_information = get_pdf_information(mediafile.mediafile)
            else:
                mediafile.pdf_information = {}
            mediafile.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [
        ("mediafiles", "0007_external_storage_1"),
    ]

    operations = [migrations.RunPython(fill_new_values)]
