# Generated by Fin Stutzenstein on 2019-20-11 16:30
from django.db import migrations


def add_poll_projection_defaults(apps, schema_editor):
    """
    Adds projectiondefaults for messages and countdowns.
    """
    Projector = apps.get_model("core", "Projector")
    ProjectionDefault = apps.get_model("core", "ProjectionDefault")
    default_projector = Projector.objects.order_by("pk").first()

    projectiondefaults = []

    projectiondefaults.append(
        ProjectionDefault(
            name="assignment_poll", display_name="Ballots", projector=default_projector
        )
    )
    projectiondefaults.append(
        ProjectionDefault(
            name="motion_poll", display_name="Motion votes", projector=default_projector
        )
    )

    # Create all new projectiondefaults
    ProjectionDefault.objects.bulk_create(projectiondefaults)


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0029_remove_history_restricted"),
    ]

    operations = [
        migrations.RunPython(add_poll_projection_defaults),
    ]
