# Generated by Django 2.1.5 on 2019-02-01 11:58

from django.db import migrations


def transform_required_permission_to_see_field(apps, schema_editor):
    """
    Sets new access_level of states to EXTENDED_MANAGERS_AND_SUBMITTER
    if required_permission_to_see is given
    """
    # We get the model from the versioned app registry;
    # if we directly import it, it will be the wrong version.
    State = apps.get_model("motions", "State")
    for state in State.objects.all():
        if state.required_permission_to_see:
            state.access_level = 1
            state.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [("motions", "0021_state_access_level_1")]

    operations = [migrations.RunPython(transform_required_permission_to_see_field)]
