# Generated by Finn Stutzenstein on 2019-07-17 08:43

from django.db import migrations


LABEL_MAPPING = {
    "default": "grey",
    "primary": "lightblue",
    "success": "green",
    "danger": "red",
    "warning": "yellow",
}


def rename_css_classes(apps, schema_editor):
    State = apps.get_model("motions", "State")

    for state in State.objects.all():
        old_class = state.css_class
        state.css_class = LABEL_MAPPING.get(old_class, "lightblue")
        state.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [("motions", "0030_state_css_classes_1")]

    operations = [migrations.RunPython(rename_css_classes)]
