# Generated by Django 2.2.2 on 2019-06-28 06:09

import os.path
from typing import List

from django.contrib.auth.models import Permission
from django.contrib.contenttypes.models import ContentType
from django.db import migrations


def change_logo_and_font_configs(apps, schema_editor):
    """
    All old paths with "/media/file/..." will be replaced with "/media/...".
    """
    ConfigStore = apps.get_model("core", "ConfigStore")

    logo_font_keys: List[str] = []
    try:
        logo_font_keys.extend(ConfigStore.objects.get(key="logos_available").value)
        logo_font_keys.extend(ConfigStore.objects.get(key="fonts_available").value)
    except ConfigStore.DoesNotExist:
        pass

    for key in logo_font_keys:
        config = ConfigStore.objects.get(key=key)
        logo = config.value
        path = logo.get("path")
        if path and path.startswith("/media/file/"):
            logo["path"] = path.replace("/media/file/", "/media/", 1)
            config.value = logo
            config.save()


def copy_filename(apps, schema_editor):
    Mediafile = apps.get_model("mediafiles", "Mediafile")

    for mediafile in Mediafile.objects.all():
        filename = os.path.basename(mediafile.mediafile.name)
        mediafile.original_filename = filename
        mediafile.save(skip_autoupdate=True)


def set_groups_and_delete_old_permissions(apps, schema_editor):
    Mediafile = apps.get_model("mediafiles", "Mediafile")
    mediafile_content_type = ContentType.objects.get(model="mediafile")
    try:
        can_see_hidden = Permission.objects.get(
            codename="can_see_hidden", content_type=mediafile_content_type
        )
        group_ids = [group.id for group in can_see_hidden.group_set.all()]
        for mediafile in Mediafile.objects.filter(hidden=True):
            mediafile.access_groups.set(group_ids)
            mediafile.save(skip_autoupdate=True)

        # Delete permissions
        can_see_hidden.delete()
        Permission.objects.filter(
            codename="can_upload", content_type=mediafile_content_type
        ).delete()
    except Permission.DoesNotExist:
        pass


class Migration(migrations.Migration):

    dependencies = [("mediafiles", "0004_directories_and_permissions_1")]

    operations = [
        migrations.RunPython(change_logo_and_font_configs),
        migrations.RunPython(copy_filename),
        migrations.RunPython(set_groups_and_delete_old_permissions),
    ]
