# Generated by Django 2.1.7 on 2019-04-25 07:00

import django.db.models.deletion
from django.db import migrations, models

import openslides.utils.models


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("agenda", "0006_auto_20190119_1425"),
    ]

    operations = [
        migrations.CreateModel(
            name="ListOfSpeakers",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                ("closed", models.BooleanField(default=False)),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="contenttypes.ContentType",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("can_see_list_of_speakers", "Can see list of speakers"),
                    ("can_manage_list_of_speakers", "Can manage list of speakers"),
                ),
                "default_permissions": (),
            },
            bases=(openslides.utils.models.RESTModelMixin, models.Model),
        ),
        migrations.AlterModelOptions(
            name="item",
            options={
                "default_permissions": (),
                "permissions": (
                    ("can_see", "Can see agenda"),
                    ("can_manage", "Can manage agenda"),
                    (
                        "can_see_internal_items",
                        "Can see internal items and time scheduling of agenda",
                    ),
                ),
            },
        ),
        migrations.AddField(
            model_name="speaker",
            name="list_of_speakers",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="speakers",
                to="agenda.ListOfSpeakers",
            ),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name="listofspeakers", unique_together={("content_type", "object_id")}
        ),
    ]
