# Generated by Finn Stutzenstein on 2019-04-29 08:51

from django.db import migrations


def rename_manager_restriction(apps, schema_editor):
    """
    Renames 'managers_only' to 'motions.can_manage'
    """
    State = apps.get_model("motions", "State")
    for state in State.objects.all():
        for i in range(len(state.restriction)):
            if state.restriction[i] == "managers_only":
                state.restriction[i] = "motions.can_manage"
        state.save(skip_autoupdate=True)


class Migration(migrations.Migration):

    dependencies = [("motions", "0025_motion_category_weight")]

    operations = [migrations.RunPython(rename_manager_restriction)]
