# OpenSlides Voting Plugin

This plugin provides electronic voting of motions and elections for OpenSlides.
It's a further development of the outdated
[OpenSlides VoteCollector Plugin](https://github.com/OpenSlides/openslides-votecollector>).


## Requirements
- OpenSlides 2.3
- [VoteCollector 1.10.1+](http://software.voteworks.eu/VoteCollector.zip) (for voting modes with keypads)


## Features

- Electronic voting for motions and elections in OpenSlides with 4 voting modes (see below) 
- Supports the voting software 'VoteCollector' for using hardware keypads of
  [Voteworks](https://www.voteworks.de) with OpenSlides.
- Overview with single votes for verification of each vote.
- Visualize live voting as delegate board on projector.
- Allows list of speakers voting (add/remove as speaker), with VoteCollector only.
- Supports multiple voting shares per delegate.
- Supports proxies/principals and absentee votes.


## Voting modes

On creation of any poll (motions and election) you will be ask which voting mode
this poll has. You can choose between four modes:

1. **Analog voting**: Just enter the offline counted votes, so the assembly can
   see the result.
2. **Named electronic voting**: Every delegate needs an OpenSlides login and can 
   vote inside of OpenSlides. It's a public vote. The name of delegate is saved to the vote.
   This can be pseudo-anonymized later (delete
   the association between user and the vote, but remember, there might be ways
   to reconstruct it later).
3. **Token-based electronic voting**: This is a mode for polling booths.
   Delegates don't need an own OpenSlides login. There have to be a few OpenSlides 
   voting machines where delegates can vote by entering a valid voting token.
   The voting tokens are randomly generated by the voting manager.
   After authenticating the delegates they get the activated voting token.
   After voting you get a (short, randomly generated) result number to
   verify your own vote in a list of all votes.
4. **VoteCollector**: If you have voting devices (keypads) that supports the
   VoteCollector, you can enable the VoteCollector mode in the settings. Note
   that not all voting methods (like yes/no/abstain for multiple candidates) are
   supported by the VoteCollector. See below for more details.

### Token-based voting interface
To run the token-based voting interface on voting machines you need to create an own
OpenSlides login, so OpenSlides can validate that the votes comes from an authorized
computer.

Create a new user group (e.g. 'voting') which has only three permissions:
`Can see motions`, `Can see assignments` and `Can see the token voting interface`.
Add this new group to a new created voting user. Now, login with this user account on voting machines.

Important: Do not give any delegate the permission `Can see the token voting interface` -
otherwise they can see no longer the default OpenSlides interface but see always the
voting interface.

If anyone should be allowed to vote at their own computer, please make a voting
user with a simple password and distribute that, so a user has to login
seperatly to vote. Note, that this may reveal the users vote because one can
check from which computer came the vote and check if a user was logged in
on the computer before.

Add `VOTING_RESULT_TOKEN_TIMEOUT` to `settings.py` if you want to change the timeout in
seconds until vote success view is closed during token-based voting. The timeout is
important so the next one cannot get the result number if the user didn't click on
continue. The result number view can be disabled by setting the timeout to 0.

### VoteCollector supported voting modes
- Yes/No/Abstain for motions
- Yes/No(/Abstain) for elections with just one candidate
- 1-of-n elections (choose one from many candidates), supports also
  abstain (key '0') and invalid votes (key > n)
- Yes/No for list of speakers voting (add/remove as speaker)

Not supported is Yes/No(/Abstain) for multiple candidates.

### Configure SECRET_KEY in VoteCollector
The VoteCollector sends the POST requests (with the important voting results) protected to
the OpenSlides server. OpenSlides and VoteCollector supports [HMAC](https://en.wikipedia.org/wiki/HMAC) - a
hashed-based message authentication code using the secret key of OpenSlides. To use
the VoteCollector successfully with OpenSlides you have to insert the `SECRET_KEY` from
OpenSlides' `settings.py` into `VoteCollector.exe.config`. If no secret key used in
VoteCollector you get an error if you start a new voting.


## Installation

### OpenSlides portable for Windows 

To install the plugin in a OpenSlides portable for Windows:

- Download and extract the zip archive of the latest plugin release from [files.openslides.org](https://files.openslides.org/plugins/openslides-voting/).
- Copy the `openslides_voting` directory into `openslides\plugins` of your OpenSlides portable.
- Restart OpenSlides server.

### Install via pypi

To install the plugin in a python environment run::
```
pip install openslides-voting
```

### Install for development
Set up Openslides as described in [DEVELOPMENT.rst of OpenSlides](https://github.com/OpenSlides/OpenSlides/blob/master/DEVELOPMENT.rst).
Then fork and clone this plugin repository. Create a
symlink from the `openslides_voting` folder into the `OpenSlides` folder from
the main OpenSlides repo:
```
ls -s /<full path>/openslides-voting/openslides_voting /<full path>/OpenSlides/openslides_voting
```
Add `openslides_voting` in your `settings.py` to `INSTALLED_PLUGINS`.

Then, from the `openslides-voting` directory, run `yarn` and for further
development a watcher:
```
node_modules/.bin/gulp watch
```

Happy Contributing!
